/*------------------------------------------------------------------------------*
 * File Name: ImpWizardSheet.h													*
 * Creation: GJL 7/11/2001														*
 * Purpose: Origin C file containing Application Utilities						*
 * Copyright (c) OriginLab Corp.	2002-2007									*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Danice 12/12/03 v7.5780 add ImpWizSourcePage and ImpWizHeadLinesPage			*
 * Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_SOURCE								*
 * Jason 12/14/03 v7.5781 ADD_USER_DEFINED_PAGE									*
 * Jason 12/19/03 v7.5781 ADD_SAVE_FILTERS_PAGE									*
 * Jason 12/14/03 v7.5781 ADD_DRAP_AND_DROP_PAGE								*
 * Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE									*
 * Jason 12/14/03 v7.5781 ADD_PLOTTING_PAGE										*
 * Jacky 12/21/03 v7.5784 ADD_DATASELECTION_PAGE                                *
 * Danice 12/23/03 v7.5786 PUT_MICRO_INSHEET									*
 * Danice 12/29/03 v7.5790 ADD_BUSY_IN_SHEET									*
 * Danice 12/30/03 v7.5790b TEMP_MOVE_TO_DIALOG									*
 * Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR							*
 * EJP 01-07-2004 v7.5796 FIX_PAGE_ORDER										*
 * Danice 1/9/04 v8.0797 ADD_PAGE_IN_ORDER										*
 *	CPY 1/14/04 v7.5801 LOST_DELIMITED_WHEN_ENTER_ASC_COL_PAGE					*
 * Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS								*
 * Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER							*
 * Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA								*
 * SY 01-28-2004 QA70-5896 v7.5808 SET_DOC_OBJECT_INFO_IN_IMPORT_WIZARD			*
 * Danice 2/12/04 v8.0819 CHANGE_GRID_TO_CLASS									*
 * EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION				*
 * EJP 07-19-2004 v8.0101 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ						*
 * EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 09-20-2004 v8.0135 QA70-6472 IMPORT_INFO_STORAGE_CLEANUP					*
 * SY 09/29/2004 v8.0142 QA70-5658 IMPROVE_HDRVAR_EXTRACTION					*
 * EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME					*
 * SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG						*
 * EJP 2005-01-28 v8.0187 IMPROVE_NUMBER_OF_PREVIEW_HEADLINES					*
 * EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS			*
 * EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC						*
 * EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA								*
 *	Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH					*
 * Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING									*
 *	Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
 *------------------------------------------------------------------------------*/

#ifndef _IMPWIZARDSHEET_H
#define _IMPWIZARDSHEET_H

class 	ImpWizSourcePage;
class 	ImpWizHeadLinesPage;
class	ImpWizDataColumnsPage;
class   ImpWizDataSelectionPage;
class	ImpWizHeadVariablesPage;

class 	ImpWizHeaderBytesPage;
class 	ImpWizDataPatternPage;

class 	ImpWizUserDefinedPage;
class	ImpWizFileTypesPage;
class	ImpWizPlottingPage;

class	ImpWizSaveFiltersPage;
class	ImpWizDrapAndDropPage;

/// EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
class IWGetVarHowPage;
class IWGetVarByDelimPage;
class IWGetVarByPosPage;
/// end IMPROVE_HDRVAR_EXTRACTION

/// EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME
class IWFileNameOptionsPage;
/// end EXTRACT_VARS_FROM_FILENAME
class ImpWizXFuncOptionsPage; /// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC

///Danice 12/15/03 v7.5783 CALL_SHEET_FUNCTION
#define s_trFilter 					m_pSheet->m_trFilter
#define s_strDataFile				m_pSheet->GetFileName()
#define s_strFilter					m_pSheet->GetFilter()
#define HDRPARAM_COUNT             	m_saHdrParamName.GetSize()
///END CALL_SHEET_FUNCTION

// Derived WizPage class for WizPage1

enum {
	NONNUMERIC_TERMINATE = 0,
	NONNUMERIC_READ_AS_MISSING,
	NONNUMERIC_START_NEW_WKSCOL,
	NONNUMERIC_APPEND_TO_LABEL
};

enum {CHANGE_NONE, CHANGE_HEX, CHANGE_ASC, CHANGE_BYTEOFFSET, CHANGE_FONT};


//--------------------------------------------------------------------------
// general definitions
//--------------------------------------------------------------------------
///#define IW_DEBUG

#define BIN_HDR_PREVIEW_BYTES_PER_ROW 	16
#define BIN_HDR_PREVIEW_NUM_ROWS		100
#define BIN_DATA_PREVIEW_NUM_BYTES		800
#define BIN_DATA_PREVIEW_BYTES_PER_ROW	20

#define IW_NUM_DATA_PREVIEW_ROWS			50
#define IW_NUM_DATA_PREVIEW_COLS			100
#define IW_NUM_HEADER_PREVIEW_LINES			m_pSheet->GetASCPreviewLines()
#define AIW_HDR_PREVIEW_LINES_DEFAULT		50

#define AIW_COLOR_DATA_LINES			RGB(192,192,192)
#define AIW_COLOR_COL_NAME				RGB(255,0,0)
#define AIW_COLOR_COL_LONG_NAME			RGB(0,0,255)
#define AIW_COLOR_HEADER_LINES			RGB(0,0,0)
#define AIW_COLOR_SUB_HEADER_LINES		RGB(128,128,0)  ///---Sim 12-14-2006 SUPPORT_AUTO_HEADER_LINES
#define AIW_COLOR_UNITS					RGB(0,255,0)
#define AIW_COLOR_COMMENTS				RGB(255,0,255)
#define AIW_COLOR_PARAMETERS			RGB(0,128,128)
#define AIW_COLOR_USER_PARAMETERS		RGB(128,0,255)  ///---Sim 01-26-2007 SUPPORT_USER_PARAMETER
#define AIW_COLOR_SKIP_LINES			RGB(192,192,192)
#define AIW_COLOR_SKIP_CHARS			AIW_COLOR_HEADER_LINES

#define AIW_COLOR_BIN_HEADER_LINES		RGB(192,192,192) ///---Sim 09-21-2006 FIX_SHOW_HEAD_LINE_IN_BINARY_PREVIEW

#define IW_PREVIEW_LINE_MAX_LEN 1024 /// EJP 08-29-2003 v7.5680 TRUNC_LONG_LINES_IN_HEADER_PREVIEW

//#define SZ_IW_PAGE_FILTER			_L("<Use filter in active window>")		///------ Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL

#define IW_PLOTTING_GRID_NUM_COLS		4
#define IW_PLOT_LINE					0
#define IW_PLOT_SCATTER					1
#define IW_PLOT_LINESYMB				2
#define IW_PLOT_COLUMN					3
#define IW_PLOT_BAR						4

#define FILTER_LOCATION_DATA			0
#define FILTER_LOCATION_ORIGIN			1
#define FILTER_LOCATION_USERFILES		2
/// Hong 8/31/06 GET_FILTER_BY_ID
//#define IS_FILTER_TYPE_ASCII			(s_trFilter.Type.nVal == FILTER_TYPE_ASCII)
//#define IS_FILTER_TYPE_BINARY			(s_trFilter.Type.nVal == FILTER_TYPE_BINARY)
//#define IS_FILTER_TYPE_USERDEFINED		(s_trFilter.Type.nVal == FILTER_TYPE_USERDEFINED)
//
///// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
//#define IS_FILTER_TYPE_XFUNC			(s_trFilter.Type.nVal == FILTER_TYPE_XFUNC)
///// end IMPWIZ_SUPPORT_XFUNC
#define IS_FILTER_TYPE_ASCII			(fuGetType(s_trFilter) == FILTER_TYPE_ASCII)
#define IS_FILTER_TYPE_BINARY			(fuGetType(s_trFilter) == FILTER_TYPE_BINARY)
#define IS_FILTER_TYPE_USERDEFINED		(fuGetType(s_trFilter) == FILTER_TYPE_USERDEFINED)

/// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
#define IS_FILTER_TYPE_XFUNC			(fuGetType(s_trFilter) == FILTER_TYPE_XFUNC)
/// end IMPWIZ_SUPPORT_XFUNC
/// end GET_FILTER_BY_ID
#define IW_HDRLINE_NONE		-1
#define IW_HDRLINE_LAST		-1

//--------------------------------------------------------------------------
// flags
//--------------------------------------------------------------------------
#define s_flags	m_pSheet->m_flags
 
#define FLAG_DEFINE_HDR_VAR				0x00000001
#define FLAG_CLICKED_FINISH				0x00000002
#define FLAG_DATAFROM_CLIPBOARD			0x00000004
#define FLAG_FIXED_WIDTHS_CHANGED		0x00000008
#define FLAG_SAVE_FILTER				0x00000010
#define FLAG_RESCAN_FOR_NUM_COLS		0x00000020 /// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
#define FLAG_ADVOPTIONS_CHECKED			0x00000040
#define FLAG_UPDATE_PREVIEW_NEEDED		0x00000080
#define FLAG_BINPATTERN_BINVIEW			0x00000100
#define FLAG_GET_FILTER_ONLY			0x00000200 /// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
#define FLAG_ON_BROWSE_SOURCE			0x00000400 /// EJP 10-16-2003 v7.5722 QA70-5289.7 UPDATE_SOURCE_FILE_ON_EDIT_CHANGE
/// EJP 11-22-2004 v8.0167 QA70-6554 EXTRACT_VARS_FROM_FILENAME
#define FLAG_VAR_BY_DELIM				0x00000800
#define FLAG_VAR_BY_POS					0x00001000
/// end EXTRACT_VARS_FROM_FILENAME

#define IS_DEFINE_HDR_VAR			(s_flags & FLAG_DEFINE_HDR_VAR)
#define ENABLE_DEFINE_HDR_VAR		s_flags |= FLAG_DEFINE_HDR_VAR
#define DISABLE_DEFINE_HDR_VAR		s_flags &= ~FLAG_DEFINE_HDR_VAR

#define IS_CLICKED_FINISH			(s_flags & FLAG_CLICKED_FINISH)
#define ENABLE_CLICKED_FINISH		m_flags |= FLAG_CLICKED_FINISH
#define DISABLE_CLICKED_FINISH		m_flags &= ~FLAG_CLICKED_FINISH

#define IS_FIXED_WIDTHS_CHANGED			(s_flags & FLAG_FIXED_WIDTHS_CHANGED)
#define SET_FIXED_WIDTHS_CHANGED		s_flags |= FLAG_FIXED_WIDTHS_CHANGED
#define SET_FIXED_WIDTHS_UNCHANGED		s_flags &= ~FLAG_FIXED_WIDTHS_CHANGED

/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
///#define IS_DATAFROM_CLIPBOARD			(s_flags & FLAG_DATAFROM_CLIPBOARD)
///#define IS_DATAFROM_CLIPBOARD2			(m_flags & FLAG_DATAFROM_CLIPBOARD)
///#define IS_DATAFROM_FILE				!IS_DATAFROM_CLIPBOARD
///#define SET_DATAFROM_CLIPBOARD			s_flags |= FLAG_DATAFROM_CLIPBOARD
///#define SET_DATAFROM_FILE				s_flags &= ~FLAG_DATAFROM_CLIPBOARD
/// end IMPROVE_DATA_CHANGE_DETECTION

#define IS_SAVE_FILTER						(s_flags & FLAG_SAVE_FILTER)
#define IS_SAVE_FILTER2						(m_flags & FLAG_SAVE_FILTER)
#define ENABLE_SAVE_FILTER					s_flags |= FLAG_SAVE_FILTER
#define DISABLE_SAVE_FILTER					s_flags &= ~FLAG_SAVE_FILTER

/// EJP 07-14-2003 v7.0624 SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES
#define IS_RESCAN_FOR_NUM_COLS				(s_flags & FLAG_RESCAN_FOR_NUM_COLS)
#define ENABLE_RESCAN_FOR_NUM_COLS			s_flags |= FLAG_RESCAN_FOR_NUM_COLS
#define DISABLE_RESCAN_FOR_NUM_COLS			s_flags &= ~FLAG_RESCAN_FOR_NUM_COLS
/// end SCAN_FOR_NUM_COLS_ON_CHANGE_HEADER_LINES

#define IS_ADVOPTIONS_ISCHECKED				(s_flags & FLAG_ADVOPTIONS_CHECKED)
#define ENABLE_ADVOPTIONS_ISCHECKED			s_flags |= FLAG_ADVOPTIONS_CHECKED
#define DISABLE_ADVOPTIONS_ISCHECKED		s_flags &= ~FLAG_ADVOPTIONS_CHECKED
#define IS_SHOW_ADVANCED					(IS_SAVE_FILTER && IS_ADVOPTIONS_ISCHECKED)

#define IS_UPDATE_PREVIEW_NEEDED		(s_flags & FLAG_UPDATE_PREVIEW_NEEDED)
#define ENABLE_UPDATE_PREVIEW_NEEDED	s_flags |= FLAG_UPDATE_PREVIEW_NEEDED
#define DISABLE_UPDATE_PREVIEW_NEEDED	s_flags &= ~FLAG_UPDATE_PREVIEW_NEEDED

#define IS_BINPATTERN_BINVIEW		(s_flags & FLAG_BINPATTERN_BINVIEW)
#define SET_BINPATTERN_BINVIEW		s_flags |= FLAG_BINPATTERN_BINVIEW
#define SET_BINPATTERN_ASCVIEW		s_flags &= ~FLAG_BINPATTERN_BINVIEW

/// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
#define IS_GET_FILTER_ONLY			(m_flags & FLAG_GET_FILTER_ONLY)
#define ENABLE_GET_FILTER_ONLY		m_Sheet.m_flags |= FLAG_GET_FILTER_ONLY
#define DISABLE_GET_FILTER_ONLY		m_Sheet.m_flags &= ~FLAG_GET_FILTER_ONLY
#define DISABLE_GET_FILTER_ONLY2	m_flags &= ~FLAG_GET_FILTER_ONLY		///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
/// end USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP

/// EJP 10-16-2003 v7.5722 QA70-5289.7 UPDATE_SOURCE_FILE_ON_EDIT_CHANGE
#define IS_ON_BROWSE_SOURCE			(s_flags & FLAG_ON_BROWSE_SOURCE)
#define ENABLE_ON_BROWSE_SOURCE		s_flags |= FLAG_ON_BROWSE_SOURCE
#define DISABLE_ON_BROWSE_SOURCE	s_flags &= ~FLAG_ON_BROWSE_SOURCE
/// end UPDATE_SOURCE_FILE_ON_EDIT_CHANGE

//#define s_strDataFile s_saDataFiles[0]
//#define NUM_DATA_FILES (IS_DATAFROM_FILE ? s_saDataFiles.GetSize() : 1)
#define NUM_DATA_FILES (IS_DATAFROM_FILE ? m_pSheet->GetDataFiles().GetSize() : 1)

/// EJP 10/01/2004 QA70-5658 v8.0143 IMPROVE_HDRVAR_EXTRACTION, move to ImpWizPage.h
///#define IW_PREVIEW_FONT 	m_pSheet->GetPreviewFont()
/// end IMPROVE_HDRVAR_EXTRACTION

//#define SZ_IW_NONE		_L("<None>")		///------ Folger 04/30/09 SHARE_IMPORT_WIZARD_FILTER_LIST_CONSTRUCTION_WITH_BATCH_PROCESS_TOOL
#define SZ_IW_ALL		_L("<All>")
#define SZ_IW_END		_L("<End>")
#define SZ_IW_DEFAULT	_L("<Default>")

///Danice 12/23/03 v7.5786 PUT_MICRO_INSHEET
#define IS_SHOW_ASC_HEADER_PAGE				IS_FILTER_TYPE_ASCII
#define IS_SHOW_ASC_HEADER_PARAM_PAGE		(IS_FILTER_TYPE_ASCII && IS_DEFINE_HDR_VAR && ASCIMP_TOTAL_HEADER_LINES(m_ascimp))
#define IS_SHOW_ASC_COLUMNS_PAGE			IS_FILTER_TYPE_ASCII
#define IS_SHOW_PARTIAL_IMPORT_PAGE			(IS_FILTER_TYPE_ASCII || IS_FILTER_TYPE_BINARY)
#define IS_SHOW_BIN_HEADER_PAGE				IS_FILTER_TYPE_BINARY
#define IS_SHOW_BIN_PATTERN_PAGE			IS_FILTER_TYPE_BINARY
#define IS_SHOW_PLOTTING_PAGE				(m_pSheet->GetActivePageType() == EXIST_PLOT)
#define IS_SHOW_SAVE_FILTER_PAGE			TRUE
#define IS_SHOW_FILE_TYPES_PAGE				IS_SHOW_ADVANCED
#define IS_SHOW_DRAG_DROP_PAGE				IS_SHOW_ADVANCED
#define IS_SHOW_USER_DEFINED_PAGE			IS_FILTER_TYPE_USERDEFINED

///END PUT_MICRO_INSHEET

// WizPage place holder class
class ImpWizSheet : public WizardSheet
{
	EVENTS_BEGIN
		PAGE_ON_INIT(InitSheet)
	EVENTS_END

public:

	// Constructor for WizardSheet class
	ImpWizSheet();
	~ImpWizSheet() {}

	// Initialize message maps for each WizPage
	bool InitSheet(string strFileName);
	
	// Data members of PropertySheet are WizPage objects
	ImpWizSourcePage*			m_WizPageSource;
	ImpWizHeadLinesPage*	 	m_WizPageHeadLines;
	ImpWizDataColumnsPage*	 	m_WizPageDataColumns;
	ImpWizDataSelectionPage* 	m_WizPageDataSelection;///Jacky 12/21/03 v7.5784 ADD_DATASELECTION_PAGE
	ImpWizHeadVariablesPage*	m_WizPageHeadVariables;
	
	ImpWizHeaderBytesPage*	 	m_WizPageHeadBytes;
	ImpWizDataPatternPage*	 	m_WizPageDataPattern;

	ImpWizUserDefinedPage*	 	m_WizPageUserDef;
	ImpWizFileTypesPage*	 	m_WizPageFileTypes;	///Jason 12/14/03 v7.5781 ADD_FILE_TYPES_PAGE
	ImpWizPlottingPage*		 	m_WizPagePlotting;		///Jason 12/14/03 v7.5781 ADD_PLOTTING_PAGE
	
	ImpWizSaveFiltersPage*	 	m_WizPageSaveFilters;	///Jason 12/14/03 v7.5781 ADD_SAVE_FILTERS_PAGE
	ImpWizDrapAndDropPage*	 	m_WizPageDrapAndDrop;	///Jason 12/14/03 v7.5781 ADD_DRAP_AND_DROP_PAGE

	/// EJP 09-10-2004 v8.0132 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	IWGetVarHowPage* m_GetVarHowPage;
	IWGetVarByDelimPage* m_GetVarByDelimPage;
	IWGetVarByPosPage* m_GetVarByPosPage;
	/// end IMPROVE_HDRVAR_EXTRACTION
	
	/// EJP 10-22-2004 v8.0154 QA70-6554 EXTRACT_VARS_FROM_FILENAME
	IWFileNameOptionsPage* m_FileNameOptionsPage;
	/// end EXTRACT_VARS_FROM_FILENAME

	/// EJP 2005-08-18 v8.0291 QA70-7996 IMPWIZ_SUPPORT_XFUNC
	ImpWizXFuncOptionsPage* m_XFuncOptionsPage;
	/// end IMPWIZ_SUPPORT_XFUNC

public :
	/// EJP 06-08-2004 v8.0886 QA70-5417 IMPROVE_DATA_CHANGE_DETECTION
	bool IsDataFromClipboard();
	void SetDataFromClipboard();
	void SetDataFromFile();
	/// end IMPROVE_DATA_CHANGE_DETECTION
	
	void EnableNextBT(bool bEnable = true);
	//void EnableBackBT(bool bEnable = true)	{EnableBackButton(bEnable);}
	void EnableFinishBT(bool bEnable = true);
	
	void IW_Init(LPCSTR lpcszFileName);
	
	BOOL OnClickFinish();

	BOOL OnClickCancel();
	
	BOOL OnDestroyDialog();

	void UpdateImpStructFromTree();
	
	///---Sim 06-23-2007 FIX_CHANGE_TO_BINARY_SETTING
	//bool iwLoadFilter(LPCSTR lpcstrFilter);
	bool iwLoadFilter(LPCSTR lpcstrFilter, int nType);
	///---END FIX_CHANGE_TO_BINARY_SETTING

	int InitComboBoxWithTemplateNames(ComboBox &cbTarget, int iType);
	
	BOOL AIW_GetTempFileName(string &strFile);
	
	void iw_SetRichEditFont(RichEdit &re, int iFont);
	
	void iw_InitComboBox(ComboBox &cb, LPCSTR lpcszStrings, int *lpiValues);

	/// EJP 2005-06-24 v8.0256 QA70-5705 ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	void SetComboBoxCurSelByData(ComboBox &cb, DWORD dwData, int nDefaultItem = 0);
	/// end ADD_NUM_SEPARATOR_TO_IMPORT_OPTIONS
	
	//--------------------------------------------------------------------------
	// UpdateImpStructCommonFromTree
	//
	// The low level import functions for ASCII and Binary get their settings
	// from a single struct argument (ASCIMP or BINIMP).
	// Copies of these structs are stored in the tree.
	// These structs have common settings.
	// These common settings are also stored in the tree's Common branch.
	// We assume the tree's Common branch is always up to date.
	// This function will update the struct from the Common branch and then
	// update the struct stored in the tree.
	//--------------------------------------------------------------------------
	void UpdateImpStructCommonFromTree();
	
	void ImportToWks(BOOL bTempWks = TRUE);
	
	void iwSetPartialImportForPreview(int& nPartial, int& nR1, int& nC1, int& nR2, int& nC2, int& nCols);
	
	///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_SOURCE
	void 	SetFileNames(const vector<string>& vsFileNames);
	void 	SetFileName(LPCSTR lpcStrFileName);

	/// EJP 01-04-2005 v8.0181 QA70-6555 USING_MULTI_OPEN_FDLOG
	///string 	GetFileName(int nIndex = 0);
	void SetFileName(int nIndex);
	string GetFileName(int nIndex = -1); // -1 = active file name
	/// end USING_MULTI_OPEN_FDLOG
	/// SY 01/06/2005 v8.0183 QA70-6555 USING_MULTI_OPEN_FDLOG
	int GetActiveDataFile();
	/// end USING_MULTI_OPEN_FDLOG
	
	vector<string> GetDataFiles();
	
	short   GetPlottingLayer(int iIndex = 0);
	void 	SetPlottingLayer(short layer, int iIndex = 0);
	
	bool 	PlotInitFirstTime();
	void 	PlotInitFirstTime(bool bFirst);
	
	///void 	SetWksName(string strWksName) {m_strWks = strWksName;}
	void 	SetWksName(LPCSTR lpcszWksName);
	string 	GetWksName();

	void 	SetFilter(string strFilter);
	string 	GetFilter();
	
	void 	SaveFilter(int IFilter);
	int 	GetSaveFilter();
	
	void	SetActivePageType(int IActivePageType);
	int 	GetActivePageType();
	
	string	GetActivePageName();
	
	void	AddPlottingLayers();
	///END ADD_NEW_FUNCTION_SOURCE
	
	///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_HEADLINES
	void 	SetPreviewFont(int IPreviewFont);
	int 	GetPreviewFont();
	
	///Danice 1/16/04 v8.0800 NEW_ACCESS_METHOD_GET_POINTER
	ASCIMP*	GetASCIMP_Pointer();
	///END NEW_ACCESS_METHOD_GET_POINTER

	int 	GetASCPreviewLines();
	///END ADD_NEW_FUNCTION_HEADLINES
	
	/// EJP 2005-01-28 v8.0187 IMPROVE_NUMBER_OF_PREVIEW_HEADLINES
	void SetASCPreviewLines(int nLines) {m_iAscHdrPreviewLines = nLines;}
	/// end IMPROVE_NUMBER_OF_PREVIEW_HEADLINES

	///Danice 12/15/03 v7.5783 ADD_NEW_FUNCTION_HEADBYTES
	void 	SetBinPreviewLines(int IBinHdrPreviewLines);
	int 	GetBinPreviewLines();
	
	BINIMP*		GetBINIMP_Pointer();
	
	void 	SetUserChange(int IUserChange);
	int 	GetUserChange();
	///END ADD_NEW_FUNCTION_HEADBYTES
	
	void	SetHdrParam(const vector<string>& vsParamName, const vector<int>& viHdrParamType, const vector<int>& viHdrParamOffset, const vector<int>& viHdrParamSize) ;
	void	GetHdrParam(vector<string>& vsParamName, vector<int>& viHdrParamType,vector<int>& viHdrParamOffset,vector<int>& viHdrParamSize) ;
	
	///Danice 12/19/03 v7.5784 ADD_NEW_FUNCTION_DATACOLUMNS
	int		GetNumColsEstimated(); 
	void 	SetFixedWidthGridFontWidth(int IFixedWidthGridFontWidth); 
	int 	GetFixedWidthGridFontWidth();
	///END ADD_NEW_FUNCTION_DATACOLUMNS
	
	///Danice 12/29/03 v7.5790 ADD_BUSY_IN_SHEET
	bool 	IsBusy();
	void	SetBusy(bool bSet = true);
	///END ADD_BUSY_IN_SHEET

	///Danice 12/31/03 v7.5790 FOR_NEW_DIALOG_CONSTRUCTOR
	string GetstrFilterFileSaved();
	///END FOR_NEW_DIALOG_CONSTRUCTOR

	/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
	///	///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	///	bool	IsUpgradeData(bool bWrite = false);
	///	///END FOR_CONTROL_UPGRADE_DATA
	void UpgradeData(WORD flags = 0xFFFF);
	bool IsUpgradeData(WORD flag);
	/// end FOR_CONTROL_UPGRADE_DATA
	
private : 

	BOOL iwSaveFilter();

	/// EJP 08-01-2003 v7.0642 DETECT_IMPORT_SETTINGS_CHANGED
	bool iwIsLoadedFilterSettingsChanged();
	/// end DETECT_IMPORT_SETTINGS_CHANGED

	/// Hong 04/13/07 v8.0600 FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH
	//BOOL IW_PlotToActiveGraph(Page &pgData, int iFileNumber);
	BOOL IW_PlotToActiveGraph(DataRange& drPlots, int iFileNumber);
	/// end FIX_IMP_MODE_FAIL_WHEN_ACTIVE_GRAPH

	/// EJP 09-08-2003 v7.5687 QA70-5118 FIX_COMPARE_BINIMP_STRUCTS
	bool is_BINIMP_equal(BINIMP &bi1, BINIMP &bi2);
	/// end FIX_COMPARE_BINIMP_STRUCTS

	/// SY 09/29/2004 QA70-5658 v8.0142 IMPROVE_HDRVAR_EXTRACTION
public:
	void EnableFlag(DWORD dwFlag);
	void DisableFlag(DWORD dwFlag);
	BOOL IsFlagEnabled(DWORD dwFlag);
	BOOL IsFlagDisabled(DWORD dwFlag);
	/// end IMPROVE_HDRVAR_EXTRACTION	
	
public :
	// the followings are taken from old code, used to be static in c file
	// it is difficult to put these variables into private due to extensive
	// access inside each page
	DWORD	m_flags;
	Tree	m_trFilter;

	/// EJP 10-06-2004 v8.0145 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	// Make public to avoid having to have data members in each Wizard ASCII page class
	ASCIMP m_ascimp;
	BINIMP m_binimp;
	/// end IMPROVE_HDRVAR_EXTRACTION
	
private :

	string 		m_strFilterFileSaved;		/// EJP 08-08-2003 v7.0650 QA70-4073.53 USE_SAME_FILTER_FOR_MULTI_FILES_ON_FILEOPEN_AND_DRAGDROP
	string 		m_strWks;
	BOOL		m_bPlotInitFirstTime;        // Only initialize Plotting page once
	//vector<short>	m_vColWidths;			///Danice 1/16/04 v8.0800 USE_ONLY_IN_DATA_COLUMNS
	int			m_iFixedWidthGridFontWidth;
	int 		m_iOnUserChange ;			//initialize  = CHANGE_NONE;
	int 		m_iBinHdrPreviewLines;
	int 		m_iAscHdrPreviewLines;
	StringArray	m_saHdrParamName;		//HeadBytes use and ...
	
	///Danice MOVE_TO_HEADBYTES
	vector<int>	m_vHdrParamType;
	vector<int>	m_vHdrParamOffset;
	vector<int>	m_vHdrParamSize;
	///END MOVE_TO_HEADBYTES
	
	int 		m_iPreviewFont;
	int			m_iActivePageType;           // Page type of active window when wiz is launched
	StringArray	m_saDataFiles;
	int m_nActiveDataFile;
	
	string		m_strActivePageName;         // Page name of active window when wiz is launched
	string 		m_strFilterLoaded; /// EJP 08-01-2003 v7.0642 DETECT_IMPORT_SETTINGS_CHANGED
	string 		m_strFilter;
	int 		m_iSaveFilter;

	/// EJP 10-06-2004 v8.0145 QA70-5658 IMPROVE_HDRVAR_EXTRACTION
	// Make public to avoid having to have data members in each Wizard ASCII page class
	///ASCIMP 		m_ascimp;
	///BINIMP 		m_binimp;
	/// end IMPROVE_HDRVAR_EXTRACTION
	
	int			m_iNumColsEstimated; // currently used for ASCII only
	vector<short>	m_vPlottingLayers;     // Layer numbers for plotting each file 

	bool		m_bBusy;
	
	/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
	///bool		m_UpgradeData;		///Danice 1/17/04 v8.0802 FOR_CONTROL_UPGRADE_DATA
	WORD m_UpgradeData;
	/// end FOR_CONTROL_UPGRADE_DATA
};

/// EJP 2005-11-21 v8.0340 FOR_CONTROL_UPGRADE_DATA
#define IW_UPGRADE_ASCII_DATA	0x0001
#define IW_UPGRADE_BIN_DATA		0x0002
/// end FOR_CONTROL_UPGRADE_DATA

#endif //_IMPWIZARDSHEET_H